<?php

include 'connection.php';

// Check if the device name parameter is provided
if(isset($_POST['devicename'])) {
    // Get the device name parameter value
    $deviceName = $_POST['devicename'];
    
    // Delete data from users table based on the provided device name
    $sql = "DELETE FROM active WHERE devicename = :deviceName";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':deviceName', $deviceName, PDO::PARAM_STR);

    if ($stmt->execute()) {
        // Data deleted successfully
        echo "Data deleted successfully";
    } else {
        // Error in executing SQL query
        echo "Error deleting data: " . $stmt->errorInfo()[2];
    }
} else {
    // Device name parameter not provided
    echo "Device name parameter is missing";
}

?>
